// Fear Power 1/7/00
#include "g_local.h"

FILE		*ents_file;
extern void ED_CallSpawn (edict_t *ent);
char *ED_ParseEdict (char *data, edict_t *ent);
typedef struct
{
	char	*name;
	void	(*spawn)(edict_t *ent);
} spawn_t;
extern spawn_t	spawns[];
/*
==============
This stuff is taken from quake 3 arena
==============
*/
char *COM_ParseExt( char **data_p, qboolean allowLineBreaks );
/*
============================================================================

PARSING

============================================================================
*/

static	char	com_token[MAX_TOKEN_CHARS];
static	int		com_lines;

void COM_BeginParseSession( void )
{
	com_lines = 0;
}

int COM_GetCurrentParseLine( void )
{
	return com_lines;
}

char *COM_Parse( char **data_p )
{
	return COM_ParseExt( data_p, true );
}


/*
==============
COM_Parse

Parse a token out of a string
Will never return NULL, just empty strings

If "allowLineBreaks" is qtrue then an empty
string will be returned if the next token is
a newline.
==============
*/
static char *SkipWhitespace( char *data, qboolean *hasNewLines ) {
	int c;

	while( (c = *data) <= ' ') {
		if( !c ) {
			return NULL;
		}
		if( c == '\n' ) {
			com_lines++;
			*hasNewLines = true;
		}
		data++;
	}

	return data;
}

char *COM_ParseExt( char **data_p, qboolean allowLineBreaks )
{
	int c = 0, len;
	qboolean hasNewLines = false;
	char *data;

	data = *data_p;
	len = 0;
	com_token[0] = 0;

	// make sure incoming data is valid
	if ( !data )
	{
		*data_p = NULL;
		return com_token;
	}

	while ( 1 )
	{
		// skip whitespace
		data = SkipWhitespace( data, &hasNewLines );
		if ( !data )
		{
			*data_p = NULL;
			return com_token;
		}
		if ( hasNewLines && !allowLineBreaks )
		{
			*data_p = data;
			return com_token;
		}

		c = *data;

		// skip double slash comments
		if ( c == '/' && data[1] == '/' )
		{
			while (*data && *data != '\n')
				data++;
		}
		// skip /* */ comments
		else if ( c=='/' && data[1] == '*' ) 
		{
			while ( *data && ( *data != '*' || data[1] != '/' ) ) 
			{
				data++;
			}
			if ( *data ) 
			{
				data += 2;
			}
		}
		else
		{
			break;
		}
	}

	// handle quoted strings
	if (c == '\"')
	{
		data++;
		while (1)
		{
			c = *data++;
			if (c=='\"' || !c)
			{
				com_token[len] = 0;
				*data_p = ( char * ) data;
				return com_token;
			}
			if (len < MAX_TOKEN_CHARS)
			{
				com_token[len] = c;
				len++;
			}
		}
	}

	// parse a regular word
	do
	{
		if (len < MAX_TOKEN_CHARS)
		{
			com_token[len] = c;
			len++;
		}
		data++;
		c = *data;
		if ( c == '\n' )
			com_lines++;
	} while (c>32);

	if (len == MAX_TOKEN_CHARS)
	{
//		Com_Printf ("Token exceeded %i chars, discarded.\n", MAX_TOKEN_CHARS);
		len = 0;
	}
	com_token[len] = 0;

	*data_p = ( char * ) data;
	return com_token;
}



/*
==================
COM_MatchToken
==================
*/
void COM_MatchToken( char **buf_p, char *match ) {
	char	*token;

	token = COM_Parse( buf_p );
	if ( strcmp( token, match ) ) {
	//	Com_Error( ERR_DROP, "MatchToken: %s != %s", token, match );
		gi.dprintf("MatchToken: %s != %s", token, match);
	}
}
//------------------------------------------------------------------------------------
void parse_ents (char *line, edict_t *e)
{
	char *p = line;

	while( true ) 
	{
		
		char		*token;

		token = COM_Parse( &p );
		if( token[0] == 0 ) 
		{// No more tokens
			break;
		}
		if ( Q_stricmp( token, "{" ) == 0) 
		{// Start of ent
			

			while ( true ) 
			{
				token = COM_Parse( &p );

				if( Q_stricmp( token, "classname" ) == 0 ) 
				{
					char *name;

					token = COM_Parse( &p );
					name = token;
					e->classname = gi.TagMalloc(sizeof(name)+1, TAG_LEVEL);
					strcpy( e->classname, name );
				}
			/*	if( Q_stricmp( token, "name" ) == 0 ) 
				{
					char *name;

					token = COM_Parse( &p );
					name = token;
					e->name = gi.TagMalloc(sizeof(name)+1, TAG_LEVEL);
					strcpy( e->name, name );
				}*/
				else if( Q_stricmp( token, "origin" ) == 0 ) 
				{
					token = COM_Parse( &p );
					e->s.origin[0] = atoi (token);
					token = COM_Parse( &p );
					e->s.origin[1] = atoi (token);
					token = COM_Parse( &p );
					e->s.origin[2] = atoi (token) + 15;
				}
				else if( Q_stricmp( token, "spawnflags" ) == 0 ) 
				{
					token = COM_Parse( &p );
					e->spawnflags = atoi(token);
					continue;
				}
				else if( Q_stricmp( token, "health" ) == 0 ) 
				{
					token = COM_Parse( &p );
					e->health = atoi(token);
				}
				else if( Q_stricmp( token, "mass" ) == 0 ) 
				{
					token = COM_Parse( &p );
					e->mass = atoi(token);
				}
				else if( Q_stricmp( token, "health" ) == 0 ) 
				{
					token = COM_Parse( &p );
					e->health = atoi(token);
				}
				else if( Q_stricmp( token, "currentcash" ) == 0 ) 
				{
					token = COM_Parse( &p );
					e->currentcash = atoi(token);
				}
				else if( Q_stricmp( token, "cast_group" ) == 0 ) 
				{
					token = COM_Parse( &p );
					e->cast_group = atoi(token);
				}
				else if( Q_stricmp( token, "target" ) == 0 ) 
				{
					token = COM_Parse( &p );
					strcpy (e->target , token);
				}
				else if( Q_stricmp( token, "targetname" ) == 0 ) 
				{
					token = COM_Parse( &p );
					strcpy (e->targetname , token);
				}
				else if ( Q_stricmp( token, "}" ) == 0 ) 
				{
					
				//	gi.dprintf("%s %s\n", e->classname, vtos(e->s.origin));
					ED_CallSpawn (e);
					break;// End ent
				}

			}
		}
	}
}

void clear_level ()
{
	edict_t *from;

	for ( from = g_edicts; from < &g_edicts[globals.num_edicts]; from++)
	{
		if (from->client)
			continue;
		if (!from->inuse)
			continue;
		if (!from->classname)
			continue;
		if ((int)from->s.origin[0] == 0 ||
			(int)from->s.origin[1] == 0 ||
			(int)from->s.origin[2] == 0)
			continue;
		if (from->classname[0] == 'f')// func
			continue;
		if (from->classname[0] == 'l')// light
			continue;
		if (from->classname[0] == 'j')// junior
			continue;
		if (from->classname[0] == 't')// target
			continue;
			G_FreeEdict(from);
	}
}
void read_level ()
{
	char		file_name[256];
	char		info[8192], line[64];// info is massive!
	cvar_t		*game_dir;
	game_dir = gi.cvar ("game", "", 0);	

#ifdef UNIX
	sprintf(file_name, "./%s/ents/%s.ent", game_dir->string, level.mapname); 
#else
	sprintf(file_name, ".\\%s\\ents\\%s.ent", game_dir->string, level.mapname);
#endif

	if (ents_file = fopen(file_name, "r")) 
	{
		int i=0;

		while ( fgets(line, 64, ents_file) )
		{
			strcpy (info + i, line);
			i += strlen(line);

			if (strstr(line, "}"))
			{
				char *s;
				edict_t *ent = G_Spawn();
			//	printf("%s", line);
				s = info;
				parse_ents(s, ent);
				info[0] = 0;
				i = 0;
			}
		}
		fclose(ents_file);
	}
	else
		gi.dprintf("couldnt open %s\n", file_name);
}

void write_ent (edict_t *e)
{
	if (!e->classname)
		return;
	if (e->item && !e->item->classname)
		return;
	if (e->client)
		return;
//	if (e->owner)// generated during play usually
//		return;
	if ((int)e->s.origin[0] == 0 ||
		(int)e->s.origin[1] == 0 ||
		(int)e->s.origin[2] == 0)
		return;
	if (!e->inuse)
		return;
	if (e->classname[0] == 'f')// func
		return;
	if (e->classname[0] == 'l')// light
		return;
	if (e->classname[0] == 'j')// junior
		return;
	if (e->classname[0] == 't')// target ??
		return;

	fprintf(ents_file, "{\n");


	if (e->item)
	{
		fprintf(ents_file, "\"classname\" \"%s\"\n", e->item->classname);
	//	gi.dprintf( "i %s\n", e->item->classname);
	}
	else 
	{
		fprintf(ents_file, "\"classname\" \"%s\"\n", e->classname);
	//	gi.dprintf( "w %s\n", e->classname);
	}

	fprintf(ents_file, "\"origin\" \"%d\" \"%d\" \"%d\"\n", 
		(int)e->s.origin[0], 
		(int)e->s.origin[1], 
		(int)e->s.origin[2] );

	if (e->spawnflags)
		fprintf(ents_file, "\"spawnflags\" \"%d\"\n", e->spawnflags);
	if (e->mass)
		fprintf(ents_file, "\"mass\" \"%d\"\n", e->mass);
	if (e->health)
		fprintf(ents_file, "\"health\" \"%d\"\n", e->health);
	if (e->currentcash)
		fprintf(ents_file, "\"currentcash\" \"%d\"\n", e->currentcash);
	if (e->target)
		fprintf(ents_file, "\"target\" \"%s\"\n", e->target);
	if (e->targetname)
		fprintf(ents_file, "\"targetname\" \"%s\"\n", e->targetname);
	if (e->angle)
		fprintf(ents_file, "\"angle\" \"%d\"\n", (int)e->s.angles[1]);

	fprintf(ents_file, "}\n");

}

void write_level ()
{
	char		file_name[256];
	cvar_t		*game_dir;
	game_dir = gi.cvar ("game", "", 0);	

#ifdef UNIX
	sprintf(file_name, "./%s/ents/%s.ent", game_dir->string, level.mapname); 
#else
	sprintf(file_name, ".\\%s\\ents\\%s.ent", game_dir->string, level.mapname);
#endif


	if (ents_file = fopen(file_name, "w"))
	{
		edict_t *from;

		fprintf(ents_file, "// Ents file for Power Kingpin, %s\n", level.mapname);
		fprintf(ents_file, "// Automatically generated. Do not Change\n");

		for ( from = g_edicts; from < &g_edicts[globals.num_edicts]; from++)
			write_ent( from );	
		fprintf(ents_file, "// End of File\n");
		fclose(ents_file);
		gi.dprintf("created %s\n", file_name);

	}
	else
		gi.dprintf("couldnt create %s\n", file_name);
}



void read_ents_file (char *filename)
{
	char		file_name[256];
	char		info[8192], line[64];// info is massive!
	cvar_t		*game_dir;
	game_dir = gi.cvar ("game", "", 0);	

#ifdef UNIX
	sprintf(file_name, "./%s/ents/%s", game_dir->string, filename); 
#else
	sprintf(file_name, ".\\%s\\ents\\%s", game_dir->string, filename);
#endif

	if (ents_file = fopen(file_name, "r")) 
	{
		int i=0;

		while ( fgets(line, 64, ents_file) )
		{
			strcpy (info + i, line);
			i += strlen(line);

			if (strstr(line, "}"))
			{
				char *s;
				edict_t *ent = G_Spawn();
			//	printf("%s", line);
				s = info;
				parse_ents(s, ent);
				info[0] = 0;
				i = 0;
			}
		}
		fclose(ents_file);
	}
	else
		gi.dprintf("couldnt open %s\n", file_name);
}